VERSION 2.00
Begin MDIForm mdiMain 
   Caption         =   "Mini-Notes"
   ClientHeight    =   4050
   ClientLeft      =   1215
   ClientTop       =   2985
   ClientWidth     =   7965
   Height          =   4740
   Left            =   1155
   LinkTopic       =   "MDIForm1"
   Top             =   2355
   Width           =   8085
   Begin SSPanel pnlBtns 
      Align           =   1  'Align Top
      Alignment       =   1  'Left Justify - MIDDLE
      BorderWidth     =   1
      Height          =   390
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   7965
      Begin FMSG fmsg2 
         frmName         =   "msg"
         IsClient        =   0   'False
         Left            =   6930
         Top             =   0
      End
      Begin SSRibbon btnMain 
         AutoSize        =   0  'None
         Height          =   330
         Index           =   5
         Left            =   435
         PictureUp       =   MDINOTES.FRX:0000
         Tag             =   "SAVE"
         Top             =   30
         Width           =   360
      End
      Begin SSRibbon btnMain 
         AutoSize        =   0  'None
         Height          =   330
         Index           =   4
         Left            =   2145
         PictureUp       =   MDINOTES.FRX:05A2
         Tag             =   "TILE.HORZ"
         Top             =   30
         Width           =   360
      End
      Begin SSRibbon btnMain 
         AutoSize        =   0  'None
         Height          =   330
         Index           =   3
         Left            =   1800
         PictureUp       =   MDINOTES.FRX:0ACC
         Tag             =   "TILE.VERT"
         Top             =   30
         Width           =   360
      End
      Begin SSRibbon btnMain 
         AutoSize        =   0  'None
         Height          =   330
         Index           =   2
         Left            =   1350
         PictureUp       =   MDINOTES.FRX:0FF6
         Tag             =   "FIND"
         Top             =   30
         Width           =   360
      End
      Begin SSRibbon btnMain 
         AutoSize        =   0  'None
         Height          =   330
         Index           =   1
         Left            =   900
         PictureUp       =   MDINOTES.FRX:1570
         Tag             =   "PRINT"
         Top             =   30
         Width           =   360
      End
      Begin SSRibbon btnMain 
         AutoSize        =   0  'None
         Height          =   330
         Index           =   0
         Left            =   90
         PictureUp       =   MDINOTES.FRX:1AEA
         Tag             =   "NEW"
         Top             =   30
         Width           =   360
      End
      Begin FMSG fmsg1 
         frmName         =   "mininotes"
         IsClient        =   0   'False
         Left            =   6450
         Top             =   0
      End
   End
   Begin SSPanel pnlMsgs 
      Align           =   2  'Align Bottom
      Alignment       =   1  'Left Justify - MIDDLE
      BevelInner      =   1  'Inset
      BorderWidth     =   1
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   3735
      Width           =   7965
   End
   Begin Menu mnuTop 
      Caption         =   "&File"
      Index           =   0
      Begin Menu mnuFile 
         Caption         =   "&New"
         Index           =   0
         Shortcut        =   ^N
         Tag             =   "NEW"
      End
      Begin Menu mnuFile 
         Caption         =   "&Open"
         Index           =   1
         Shortcut        =   ^O
         Tag             =   "OPEN"
      End
      Begin Menu mnuFile 
         Caption         =   "-"
         Index           =   2
      End
      Begin Menu mnuFile 
         Caption         =   "&Save"
         Index           =   3
         Shortcut        =   ^S
         Tag             =   "SAVE"
      End
      Begin Menu mnuFile 
         Caption         =   "Save &As"
         Index           =   4
         Shortcut        =   ^A
         Tag             =   "SAVE.AS"
      End
      Begin Menu mnuFile 
         Caption         =   "Sa&ve All"
         Index           =   5
         Tag             =   "SAVE.ALL"
      End
      Begin Menu mnuFile 
         Caption         =   "-"
         Index           =   6
      End
      Begin Menu mnuFile 
         Caption         =   "&Print"
         Index           =   7
         Shortcut        =   ^P
         Tag             =   "PRINT"
      End
      Begin Menu mnuFile 
         Caption         =   "-"
         Index           =   8
      End
      Begin Menu mnuFile 
         Caption         =   "&Exit"
         Index           =   9
         Tag             =   "EXIT"
      End
   End
   Begin Menu mnuTop 
      Caption         =   "&Edit"
      Index           =   1
      Begin Menu mnuEdit 
         Caption         =   "&Cut"
         Index           =   0
         Shortcut        =   ^X
         Tag             =   "EDIT.CUT"
      End
      Begin Menu mnuEdit 
         Caption         =   "&Copy"
         Index           =   1
         Tag             =   "EDIT.COPY"
      End
      Begin Menu mnuEdit 
         Caption         =   "&Paste"
         Index           =   2
         Shortcut        =   ^V
         Tag             =   "EDIT.PASTE"
      End
      Begin Menu mnuEdit 
         Caption         =   "-"
         Index           =   3
      End
      Begin Menu mnuEdit 
         Caption         =   "&Find"
         Index           =   4
         Shortcut        =   ^F
         Tag             =   "FIND.DLG"
      End
      Begin Menu mnuEdit 
         Caption         =   "&Find Next"
         Index           =   5
         Shortcut        =   {F3}
         Tag             =   "FIND.NEXT"
      End
   End
   Begin Menu mnuTop 
      Caption         =   "&Help"
      Index           =   2
      Begin Menu mnuHelp 
         Caption         =   "Contents"
         Index           =   0
      End
      Begin Menu mnuHelp 
         Caption         =   "-"
         Index           =   1
      End
      Begin Menu mnuHelp 
         Caption         =   "&Help on Help"
         Index           =   2
      End
      Begin Menu mnuHelp 
         Caption         =   "-"
         Index           =   3
      End
      Begin Menu mnuHelp 
         Caption         =   "&About"
         Index           =   4
      End
   End
End
'================================================================================
'
'   mdiNotes.frm
'
'   This is a simple notepad-like program that uses the FMSG.VBX custom control
'
'================================================================================
'Change History:
'
    Const cVersion = "961023"

'   Date    who     Description
'   ======= ======= ===============================
'
'================================================================================
'NOTES:
'
'   re      HowToRegister function
'           this example demonstrates the HowToRegister function
'
'   re      Multiple fmsg's on a single form
'           This example demonstrates how to use more than one fmsg on a single form
'           In this example, the user message bar has its own "fmsg".  Any user messages
'           that need to be displayed can be show by a simple fCall.
'           (think of the message bar as being a "service" to all forms.)
'           Note that I could have added another fmsg to handle the toolbar.
'           (this would allow all forms to send messages to the toolbar advising them of their
'           current status, to hide/gray buttons, etc.)
'
'================================================================================
'Turn on my favorite options:

    Option Explicit
    Option Base 1

'================================================================================
'Local variables:

Sub btnMain_Click (Index As Integer, Value As Integer)

    If Value Then
        btnMain(Index).Value = False    'pop the button back up
        Select Case strUT((btnMain(Index).Tag))
            Case "TILE.VERT"
                Me.Arrange TILE_VERTICAL
            Case "TILE.HORZ"
                Me.Arrange TILE_HORIZONTAL
            Case "NEW"
                fCall fmsg1, "note", "NEW"
            Case Else
                fCall fmsg1, "-1", (btnMain(Index).Tag)
        End Select
    End If

End Sub

Sub fmsg1_Exec (hBuff As Integer, IsDone As Integer)

    Select Case fVerb(hBuff)
        Case "VERSION"
            fRet1 hBuff, cVersion

        Case "CREATE"
            Select Case strUT(fIn1(hBuff))
                Case "DLGFIND"
                    voidI = Shell(appPath() & "dlgfind.exe")    'create an instance of dlgfind
                Case "NOTE"
                    Dim nn As New frmNote
                    voidI = nn.Visible          'create another instance of a NOTE
            End Select
        Case Else
            fmsgExecDefault Me, fmsg1, hBuff
    End Select

    fmsgErrCk hBuff

End Sub

Sub fmsg2_Exec (hBuff As Integer, IsDone As Integer)
    
    'here's an example of how to use two fmsg's on a single form
    '   all of the messages to MSG will come here
    
    Select Case fVerb(hBuff)
        Case "WARN"
            pnlMsgs = fIn1(hBuff)
            pnlMsgs.BackColor = colorWarn
            Beep
        Case "SHOW"
            pnlMsgs = fIn1(hBuff)
            pnlMsgs.BackColor = colorNormal
        Case "ERROR"
            pnlMsgs = fIn1(hBuff)
            pnlMsgs.BackColor = colorError
            Beep
    End Select

End Sub

Sub MDIForm_Load ()

    fCall1 fmsg1, "msg", "show", "MiniNotes Program Version " & cVersion & "."

    'here are some examples of how to use the HowToRegister function:
        voidI = fHowtoRegister(fmsg1, "dlgfind", "CREATE", "dlgfind", "")
        voidI = fHowtoRegister(fmsg1, "note", "CREATE", "note", "")
    
End Sub

Sub MDIForm_QueryUnload (Cancel As Integer, UnloadMode As Integer)

    If UnloadMode <> 1 Then
        If fCloseAll(fmsg1) Then
            Cancel = True
            fCall1 fmsg1, "msg", "Warn", "Close Cancelled."
        End If
    End If

End Sub

Sub mnuEdit_Click (Index As Integer)

    If Len(mnuEdit(Index).Tag) <> 0 Then
        fCall fmsg1, "-1", (mnuEdit(Index).Tag)
    End If
    
End Sub

Sub mnuFile_Click (Index As Integer)

    Select Case strUT((mnuFile(Index).Tag))
        Case "NEW"
            fCall fmsg1, "note", "new"
        Case "OPEN"
            fCall fmsg1, "note", "open"
        Case "SAVE.ALL"
            fCall fmsg1, "", "SAVE"         'broadcast a save command
        Case "EXIT"
            If fCloseAll(fmsg1) Then
                fCall1 fmsg1, "msg", "warn", "Close cancelled."
            Else
                Exit Sub
            End If
        Case Else
            fCall fmsg1, "-1", (mnuFile(Index).Tag)
    End Select

End Sub

